<?php
/*  ----------------------------------------------------------------------------
    the blog index template
 */

get_header();

//set the template id, used to get the template specific settings - this was the old home.php template
$template_id = 'home';

//prepare the loop variables
global $loop_module_id, $loop_sidebar_position;
$loop_module_id = td_util::get_option('tds_' . $template_id . '_page_layout', 15); //module 1 is default
$loop_sidebar_position = td_util::get_option('tds_' . $template_id . '_sidebar_pos'); //sidebar right is default (empty)

// sidebar position used to align the breadcrumb on sidebar left + sidebar first on mobile issue
$td_sidebar_position = '';
if($loop_sidebar_position == 'sidebar_left') {
	$td_sidebar_position = 'td-sidebar-left';
}

//used if file exists in child theme
$td_child_theme_file_path = STYLESHEETPATH . '/loop.php';

?>

<div class="td-main-content-wrap td-container-wrap">

    <div class="td-container td-blog-index <?php echo esc_attr($td_sidebar_position) ?>">
        <div class="td-crumb-container">
            <?php echo td_page_generator::get_home_breadcrumbs(); ?>
        </div>
        <div class="td-pb-row">
            <?php
            switch ($loop_sidebar_position) {
                default:
                    ?>
                        <div class="td-pb-span8 td-main-content">
                            <div class="td-ss-main-content">
                                <?php
                                if ( defined('TD_STANDARD_PACK' ) ) {
                                    if ( is_child_theme() && file_exists( $td_child_theme_file_path ) ) {
                                        require_once($td_child_theme_file_path);
                                    }
                                    require_once(TDSP_THEME_PATH . '/loop.php');
                                } else {
                                    if ( is_child_theme() && file_exists( $td_child_theme_file_path ) ) {
                                        require_once($td_child_theme_file_path);
                                    }
                                    require_once('loop.php');
                                }

                                    echo td_page_generator::get_pagination();
                                ?>
                            </div>
                        </div>
                        <div class="td-pb-span4 td-main-sidebar">
                            <div class="td-ss-main-sidebar">
                                <?php get_sidebar(); ?>
                            </div>
                        </div>
                    <?php
                    break;

                case 'sidebar_left':
                    ?>
                    <div class="td-pb-span8 td-main-content <?php echo esc_attr($td_sidebar_position) ?>-content">
                        <div class="td-ss-main-content">
                            <?php
                            if ( defined('TD_STANDARD_PACK' ) ) {
                                if ( is_child_theme() && file_exists( $td_child_theme_file_path ) ) {
                                    require_once($td_child_theme_file_path);
                                }
                                require_once(TDSP_THEME_PATH . '/loop.php');
                            } else {
                                if ( is_child_theme() && file_exists( $td_child_theme_file_path ) ) {
                                    require_once($td_child_theme_file_path);
                                }
                                require_once('loop.php');
                            }
                                echo td_page_generator::get_pagination();
                            ?>
                        </div>
                    </div>
	                <div class="td-pb-span4 td-main-sidebar">
		                <div class="td-ss-main-sidebar">
			                <?php get_sidebar(); ?>
		                </div>
	                </div>
                    <?php
                    break;

                case 'no_sidebar':
                    td_global::$load_featured_img_from_template = 'full';

                    ?>
                    <div class="td-pb-span12 td-main-content">
                        <div class="td-ss-main-content">
                            <?php
                            if ( defined('TD_STANDARD_PACK' ) ) {
                                if ( is_child_theme() && file_exists( $td_child_theme_file_path ) ) {
                                    require_once($td_child_theme_file_path);
                                }
                                require_once(TDSP_THEME_PATH . '/loop.php');
                            } else {
                                if ( is_child_theme() && file_exists( $td_child_theme_file_path ) ) {
                                    require_once($td_child_theme_file_path);
                                }
                                require_once('loop.php');
                            }
                                echo td_page_generator::get_pagination();
                            ?>
                        </div>
                    </div>
                    <?php
                    break;
            }
            ?>
        </div> <!-- /.td-pb-row -->
    </div> <!-- /.td-container -->
</div> <!-- /.td-main-content-wrap -->

<?php
get_footer();