<?php require_once('getting-started-data.php'); ?>

<section class="dusky-g-banner" style="background-image: url(<?php echo esc_url(DUSKY_ASSETS . '/images/getting-started/dusky-getting-banner-bg.jpg'); ?>);">
    <div class="dusky-g-container">
        <img src="<?php echo esc_url(DUSKY_ASSETS . '/images/getting-started/dusky-wordpress.svg'); ?>" alt="<?php esc_attr_e('Dusky Dark Mode', 'dusky-dark-mode'); ?>">
        <h1 class="dusky-g-banner-title"><?php esc_html_e('Dusky Dark Mode', 'dusky-dark-mode'); ?></h1>
        <p class="dusky-g-banner-content"><?php esc_html_e('Elevate Your Website with Dusky Dark Mode Plugin for a Stylish and User-Friendly Experience.', 'dusky-dark-mode'); ?></p>
        <?php
        if (dusky_fs()->is_not_paying()) {
            printf('<a href="%s" class="dusky-g-banner-btn">%s</a>', esc_url(dusky_fs()->get_upgrade_url()), esc_html__('Upgrade Plan', 'dusky-dark-mode'));
        } else {
            printf('<a href="%s" class="dusky-g-banner-btn">%s</a>', esc_url(admin_url('admin.php?page=dusky-dark-mode')), esc_html__('Settings', 'dusky-dark-mode'));
        }
        ?>
    </div>
</section> <!-- Dusky Getting Started Banner -->

<section class="dusky-g-tab">
    <div class="dusky-g-container">
        <ul class="dusky-g-tab-btns">
            <li data-id="dusky-introduction" class="dusky-g-tab-btn active">
                <span><img src="<?php echo esc_url(DUSKY_ASSETS . '/images/getting-started/Introduction.svg'); ?>" alt="<?php esc_attr_e('Introduction', 'dusky-dark-mode'); ?>"></span> <?php esc_html_e('Introduction', 'dusky-dark-mode'); ?>
            </li>
            <li data-id="dusky-basic-usages" class="dusky-g-tab-btn">
                <span><img src="<?php echo esc_url(DUSKY_ASSETS . '/images/getting-started/Basic-Usage.svg'); ?>" alt="<?php esc_attr_e('Basic Usages', 'dusky-dark-mode'); ?>"></span> <?php esc_html_e('Basic Usages', 'dusky-dark-mode'); ?>
            </li>
            <li data-id="dusky-basic-helps" class="dusky-g-tab-btn">
                <span><img src="<?php echo esc_url(DUSKY_ASSETS . '/images/getting-started/Help.svg'); ?>" alt="<?php esc_attr_e('Help', 'dusky-dark-mode'); ?>"></span> <?php esc_html_e('Help', 'dusky-dark-mode'); ?>
            </li>
            <li data-id="dusky-changelog" class="dusky-g-tab-btn">
                <span><img src="<?php echo esc_url(DUSKY_ASSETS . '/images/getting-started/Changelog.svg'); ?>" alt="<?php esc_attr_e('Changelog', 'dusky-dark-mode'); ?>"></span> <?php esc_html_e('Changelog', 'dusky-dark-mode'); ?>
            </li>
        </ul> <!-- Tab Button  -->

        <div class="dusky-tab-body" id="dusky-introduction">
            <div class="dusky-tab-body-banner">
                <div class="dusky-intro-wrapper">
                    <h2 class="dusky-g-sect-title"><?php esc_html_e('Quick Overview', 'dusky-dark-mode'); ?></h2>
                    <p><?php esc_html_e('Dusky Dark Mode comes up as the best dark mode plugin for WordPress, offering a transformative experience in conjunction with NightShade Pro\'s unique functionality. This plugin delivers an effective and seamless dark mode version of your website, effectively reducing eye strain for your visitors and ensuring long-lasting appeal that attracts more traffic from other websites.', 'dusky-dark-mode'); ?></p>

                    <p><?php esc_html_e('With its user and eye-friendly design, Dusky Dark Mode comes equipped with predefined presets to effortlessly match your website\'s overall aesthetic. It is the perfect solution for anyone seeking to integrate a dark mode option seamlessly into their website. Experience the convenience of live dark mode adjustments, allowing you to customize the dark mode version of your website in real-time and preview changes as you make them.', 'dusky-dark-mode'); ?></p>

                    <p><?php esc_html_e('Our admin dashboard dark mode support ensures you can work comfortably on your website even in low-light conditions, enhancing your overall user experience. Choose Dusky Dark Mode for a sophisticated and user-friendly dark mode solution that enhances both functionality and aesthetics.', 'dusky-dark-mode'); ?></p>

                </div>

                <div class="dusky-iframe-responsive">
                    <iframe src="https://www.youtube.com/embed/EZq4djWwIV8?si=wuurqaNXXlZ027Wa" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                </div>
            </div><!-- dusky-tab-body-banner -->


            <div class="dusky-auto-save dusky-g-section-spacing">
                <h2 class="dusky-g-sect-title"><?php esc_html_e('Discover the striking attributes of Dusky Dark Mode.', 'dusky-dark-mode'); ?></h2>
                <div class="dusky-features">

                    <?php
                    if (!empty($features) && is_array($features)) :
                        foreach ($features as $feature) :
                            $image = $feature['image'] ?? '';
                            $title = $feature['title'] ?? '';
                            $description = $feature['description'] ?? '';

                            $doc_link = $feature['doc_link'] ?? null;

                            if ($doc_link) {
                                printf('<a href="%s" class="dusky-auto-save-item">', esc_url($doc_link));
                            } else {
                                printf('<div class="dusky-auto-save-item">');
                            }
                    ?>

                            <img src="<?php echo esc_url(DUSKY_ASSETS . "/images/getting-started/{$image}"); ?>" alt="<?php esc_attr($title); ?>">
                            <h3><?php echo esc_html($title); ?></h3>
                            <p><?php echo esc_html($description); ?></p>

                    <?php
                            if ($doc_link) {
                                printf('</a>');
                            } else {
                                printf('</div>');
                            }
                        endforeach;
                    endif; ?>
                </div><!-- Auto Save Customization items  -->
            </div><!-- Auto Save Customization  -->

            <div class="dusky-discover-feature dusky-g-section-spacing">
                <h2 class="dusky-g-sect-title"><?php esc_html_e('Discover Every Single Feature', 'dusky-dark-mode'); ?></h2>
                <div class="dusky-discover-feature-items">
                    <?php
                    if (!empty($single_features) && is_array($single_features)) :
                        foreach ($single_features as $feature) :
                            $image = $feature['image'] ?? '';
                            $title = $feature['title'] ?? '';
                            $description = $feature['description'] ?? '';

                    ?>
                            <div class="dusky-discover-feature-item">
                                <div class="dusky-discover-feature-icon">
                                    <img src="<?php echo esc_url(DUSKY_ASSETS . "/images/getting-started/{$image}"); ?>" alt="<?php esc_attr($title); ?>">
                                </div>
                                <h4><?php echo esc_html($title); ?></h4>
                                <p><?php echo esc_html($description); ?></p>
                            </div>
                    <?php endforeach;
                    endif; ?>
                </div> <!-- dusky-discover-feature-items  -->
            </div><!-- Discover Every Single Feature  -->

        </div> <!-- Introduction  -->

        <div class="dusky-tab-body" id="dusky-basic-usages" style="display: none;">
            <div class="dusky-g-toggles">

                <?php
                if (!empty($basic_usages) && is_array($basic_usages)) :
                    foreach ($basic_usages as $index => $basic_usage) :

                        $question = $basic_usage['question'] ?? '';
                        $answer = $basic_usage['answer'] ?? '';

                ?>
                        <div class="dusky-g-toggle-item">
                            <div class="dusky-g-toggle-head<?php echo $index == 0 ? ' toggle-open' : ''; ?>">
                                <h5 class="dusky-g-toggle-title"><?php echo esc_html($question); ?></h5>
                                <span class="dusky-g-toggle-icon"></span>
                            </div>
                            <div class="dusky-g-toggle-body" style="<?php echo $index != 0 ? 'display: none' : ''; ?>">
                                <div class="dusky-default-editor">
                                    <?php echo $answer; ?>
                                </div>
                            </div>
                        </div> <!-- Item  -->

                <?php endforeach;
                endif; ?>

            </div> <!-- Toggles  -->
        </div> <!-- Basic Usage  -->

        <div class="dusky-tab-body" id="dusky-basic-helps" style="display: none;">
            <div class="dusky-help-items">
                <div class="dusky-help-item">
                    <img src="<?php echo esc_url(DUSKY_ASSETS . '/images/getting-started/Documentations.svg'); ?>" alt="<?php esc_attr_e('Documentations', 'dusky-dark-mode'); ?>">
                    <h4><?php esc_attr_e('Features Documentation', 'dusky-dark-mode') ?></h4>
                    <p><?php esc_attr_e('Check out our detailed online documentation and video tutorials to find out more.', 'dusky-dark-mode') ?></p>
                    <a target="_blank" href="https://codeconfig.dev/docs-category/dusky-dark-mode/" class="dusky-tab-button"><?php esc_attr_e('Documentation', 'dusky-dark-mode') ?></a>
                </div>

                <div class="dusky-help-item">
                    <img src="<?php echo esc_url(DUSKY_ASSETS . '/images/getting-started/Contact.svg'); ?>" alt="<?php esc_attr_e('Contact', 'dusky-dark-mode'); ?>">
                    <h4><?php esc_attr_e('Best Customer Support', 'dusky-dark-mode') ?></h4>
                    <p><?php esc_attr_e('We have dedicated support team to provide you fast, friendly & top-notch support.', 'dusky-dark-mode') ?></p>
                    <a target="_blank" href="https://codeconfig.dev/contact/" class="dusky-tab-button"><?php esc_attr_e('Contact US', 'dusky-dark-mode') ?></a>
                </div>
            </div>
        </div> <!-- Basic Usage  -->

        <div class="dusky-tab-body" id="dusky-changelog" style="display: none;">
            <div class="dusky-tab-body-banner">
                <h2 class="dusky-g-sect-title"><?php esc_html_e("What's new in the latest changes", 'dusky-dark-mode'); ?></h2>
                <p><?php esc_html_e("Check out the latest change logs.", 'dusky-dark-mode'); ?></p>
            </div><!-- dusky-tab-body-banner -->
            <div class="dusky-g-toggles">

                <?php
                if (!empty($changelogs) && is_array($changelogs)) :
                    foreach ($changelogs as $index => $changelog) :

                        $version = $changelog['version'] ?? '';
                        $date = $changelog['date'] ?? '';
                        $changes = $changelog['changes'] ?? '';

                ?>
                        <div class="dusky-g-toggle-item">
                            <div class="dusky-g-toggle-head<?php echo $index == 0 ? ' toggle-open' : ''; ?>">
                                <span class="dusky-g-toggle-icon"></span>
                                <h5 class="dusky-g-toggle-title"><span class="dusky-verson"><?php echo esc_html($version); ?></span> <span class="dusky-ver-date"><?php echo esc_html($date); ?></span></h5>
                            </div>
                            <div class="dusky-g-toggle-body" style="<?php echo $index != 0 ? 'display: none' : ''; ?>">
                                <?php if (!empty($changes) && is_array($changes)) :
                                    foreach ($changes as $key => $value) :
                                        if (!empty($value) && is_array($value)) :
                                            printf('<div class="changing-item log-%1s"><h6>%s</h6>', esc_attr($key), esc_attr(str_replace('-', ' ', ucfirst($key))));

                                            foreach ($value as $log_item) : ?>
                                                <p><?php echo esc_html($log_item); ?></p>
                                <?php endforeach;
                                            echo '</div>';
                                        endif;
                                    endforeach;
                                endif; ?>
                            </div>
                        </div> <!-- Item  -->

                <?php endforeach;
                endif; ?>

            </div> <!-- Toggles  -->
        </div> <!-- Basic Usage  -->
    </div><!-- Dusky Container  -->
</section> <!-- Dusky Tab  -->