<?php

$features = [
    [
        'image'       => 'auto-save-customization.svg',
        'doc_link'    => '',
        'title'       => __('Auto Save Customization', 'dusky-dark-mode'),
        'description' => __('Enjoy hassle-free customization with Auto Save by Dusky Dark Mode. Your tweaks are automatically saved, ensuring a worry-free experience. Customize with ease and let Auto Save handle the rest.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'frontend-dark-mode.svg',
        'title'       => __('Frontend Dark Mode', 'dusky-dark-mode'),
        'description' => __('Experience the Frontend Dark Mode, a feature that transforms your website\'s appearance as users interact. Ideal for those spending extended periods on your site\'s frontend.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'admin-dashboard.svg',
        'title'       => __('Admin Dashboard Dark Mode', 'dusky-dark-mode'),
        'description' => __('Utilize Dusky Dark Mode to enable a consistent dark mode in your admin dashboard. This ensures a unified look and reduces eye strain during admin tasks.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'dynamic-color.svg',
        'title'       => __('Dynamic, Presets and Custom Colors', 'dusky-dark-mode'),
        'description' => __('Harness the power of Dusky Dark Mode\'s smart dynamic algorithm, effortlessly generating dark mode color schemes for your website.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'awesome-toggle-buttons.svg',
        'title'       => __('40+ Awesome Toggle Button Styles', 'dusky-dark-mode'),
        'description' => __('Dusky Dark Mode offers a variety of toggle button styles, with 40+ options for seamless switching between light and dark mode. Customize these buttons to match your site\'s.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'toggle-placement.svg',
        'title'       => __('Customizable Toggle Placement', 'dusky-dark-mode'),
        'description' => __('Dive into Dusky Dark Mode\'s varied toggle options, effortlessly transitioning between light and dark modes. Elevate accessibility and seamlessly blending options with your site\'s.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'live-dark-mode-editing.svg',
        'title'       => __('Live Dark Mode Editing', 'dusky-dark-mode'),
        'description' => __('Explore the Live Edit Widget in the Dark Mode plugin, enabling real-time customization of your dark mode theme. Save valuable time with instant adjustments to colors, toggle buttons, typography, and more.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'dark-mode-analytics.svg',
        'title'       => __('Dark Mode Usage Analytics', 'dusky-dark-mode'),
        'description' => __('Track user engagement with detailed usage analytics from Dusky Dark Mode. Monitor dark mode usage, enable/disable frequencies, and gain valuable insights into user preferences.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'adjustable-color.svg',
        'title'       => __('Adjustable Colors Style', 'dusky-dark-mode'),
        'description' => __('Fine-tune your dark mode experience with advanced color adjustments, including brightness, contrast, sepia, and grayscale options. Perfect for users with visual impairments.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'auto-match-os-theme.svg',
        'title'       => __('Auto Match OS Theme', 'dusky-dark-mode'),
        'description' => __('Automatic detection of a user\'s device OS theme ensures seamless integration with their device\'s dark mode setting. Enjoy a consistent dark mode experience based on individual preferences.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'flotting-toggle.svg',
        'title'       => __('Floating Toggle Button', 'dusky-dark-mode'),
        'description' => __('Discover the convenience of a floating dark mode toggle button with 40+ attractive styles. Easily switch between light and dark modes regardless of your location on the website.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'image-video-replacement.svg',
        'title'       => __('Image & Video Replacements', 'dusky-dark-mode'),
        'description' => __('Tailor your dark mode experience by replacing images and videos that may not look optimal. Dusky Dark Mode allows you to substitute light-mode media with dark mode alternatives.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'gutenberg--classic-editor.svg',
        'title'       => __('Gutenberg & Classic Editor Compatibility Everywhere', 'dusky-dark-mode'),
        'description' => __('Compatible with both classic and block editors, Dusky Dark Mode enhances the editing experience in WordPress. Ideal for users who spend significant time creating.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'custom-css.svg',
        'title'       => __('Custom CSS Styling', 'dusky-dark-mode'),
        'description' => __('Inject your personal touch with Custom CSS in Dusky Dark Mode. Customize the appearance of your website when in dark mode to align with your unique style.', 'dusky-dark-mode'),
    ],
];

$single_features = [
    [
        'image'       => 'toggle-button.svg',
        'title'       => __('Toggle Button Shortcode', 'dusky-dark-mode'),
        'description' => __('Seamlessly incorporate a dark mode toggle button anywhere on your website using the [dusky_toggle] shortcode.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'default-dark-mode.svg',
        'title'       => __('Default Dark Mode Setting', 'dusky-dark-mode'),
        'description' => __('Establish Dusky Dark Mode as your website\'s default theme, ensuring first-time visitors experience this.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Performance-Enhancement.svg',
        'title'       => __('Performance Enhancement', 'dusky-dark-mode'),
        'description' => __('Activate Performance Mode to optimize website loading speed by deferring script loading, thereby reducing page load times.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Dashboard-customization.svg',
        'title'       => __('Dashboard Customization for Specific Users', 'dusky-dark-mode'),
        'description' => __('Administrators, editors, and authors to use the dark mode color scheme on dashboards.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Customizable-Toggle-Button.svg',
        'title'       => __('Customizable Toggle Button', 'dusky-dark-mode'),
        'description' => __('Tailor the dark mode toggle button size to your preference - choose from small, normal, large, or customize its width and height.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Toggle-Positioning.svg',
        'title'       => __('Flexible Toggle Button Positioning', 'dusky-dark-mode'),
        'description' => __('Place the dark mode toggle button on the left, right, or in a specific location on the site.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Dark-Mode-Typography.svg',
        'title'       => __('Dark Mode Typography', 'dusky-dark-mode'),
        'description' => __('Personalize the font family and size when dark mode is enabled to significantly enhance readability and legibility.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Include-Elements.svg',
        'title'       => __('Include Elements, Page, Posts', 'dusky-dark-mode'),
        'description' => __('Opt for dark mode on specific elements, pages, or posts by including them for a more tailored experience.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Excludes-Specific-Elements.svg',
        'title'       => __('Excludes any Specific Elements', 'dusky-dark-mode'),
        'description' => __('Specify elements, pages, or posts to exclude from dark mode for easy customization.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Custom-CSS-Support.svg',
        'title'       => __('Custom CSS Support', 'dusky-dark-mode'),
        'description' => __('Inject your custom CSS code to personalize the appearance of the website in both light and dark modes.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Builder-Compatibility.svg',
        'title'       => __('Wide Page Builder Compatibility', 'dusky-dark-mode'),
        'description' => __('Experience compatibility with popular page builders like Classic Editor, Gutenberg, Elementor.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Export-Import.svg',
        'title'       => __('Export, Import, Reset Settings', 'dusky-dark-mode'),
        'description' => __('Effortlessly manage settings with the option to export, import, or reset configurations.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Time-Based.svg',
        'title'       => __('Time-Based Dark Mode', 'dusky-dark-mode'),
        'description' => __('Schedule dark mode activation based on the time of day.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'URL-Parameter-Control.svg',
        'title'       => __('URL Parameter Control', 'dusky-dark-mode'),
        'description' => __('Enable/disable dark mode by adding the darkmode and lightmode parameters to the website URL.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Draggable-Floating-Switch.svg',
        'title'       => __('Draggable Floating Switch', 'dusky-dark-mode'),
        'description' => __('Allow users to effortlessly drag the floating dark mode toggle button to their desired position on the screen.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Keyboard-Shortcut-Convenience.svg',
        'title'       => __('Keyboard Shortcut Convenience', 'dusky-dark-mode'),
        'description' => __('Seamlessly switch between light and dark mode using the keyboard shortcut (Ctrl + Alt + D).', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Gutenberg-Toggle-Block.svg',
        'title'       => __('Gutenberg Dark Mode Toggle Switch Block', 'dusky-dark-mode'),
        'description' => __('Embed a dark mode switch directly within the Gutenberg editor for easy reader access.', 'dusky-dark-mode'),
    ],
    [
        'image'       => 'Elementor-Dark-Block.svg',
        'title'       => __('Elementor Dark Mode Toggle Block', 'dusky-dark-mode'),
        'description' => __('Effortlessly add a dark mode toggle to your Elementor designs.', 'dusky-dark-mode'),
    ],
];

$changelogs = [
    [
        'version' => __('v1.0.15', 'dusky-dark-mode'),
        'date'    => __('2025-02-05', 'dusky-dark-mode'),
        'changes' => [
            'enhancements' => [
                __('Improved plugin performance and optimization. ', 'dusky-dark-mode')
            ],
        ],
    ],
    [
        'version' => __('v1.0.14', 'dusky-dark-mode'),
        'date'    => __('2025-01-08', 'dusky-dark-mode'),
        'changes' => [
            'fixes' => [
                __('Resolved classic editor issue.', 'dusky-dark-mode')
            ],
        ],
    ],
    [
        'version' => __('v1.0.13', 'dusky-dark-mode'),
        'date'    => __('2024-12-03', 'dusky-dark-mode'),
        'changes' => [
            'fixes' => [
                __('Resolved an issue where the default dark mode was not functioning correctly when a caching plugin was active.', 'dusky-dark-mode')
            ],
            'enhancements'   => [
                __('Verified compatibility with the latest WordPress version.', 'dusky-dark-mode'),
            ],
        ],
    ],
    [
        'version' => __('v1.0.12', 'dusky-dark-mode'),
        'date'    => __('2024-03-12', 'dusky-dark-mode'),
        'changes' => [
            'fixes' => [
                __('Improved compatibility with caching plugins.', 'dusky-dark-mode'),
            ],
            'new'   => [
                __('Added support for device-specific dark mode settings.', 'dusky-dark-mode'),
            ],
        ],
    ],
    [
        'version' => __('v1.0.11', 'dusky-dark-mode'),
        'date'    => __('2024-19-08', 'dusky-dark-mode'),
        'changes' => [
            'fixes' => [
                __('Fix Frontend toggle issue for logout user.'),
            ],
            'new'   => [
                __('Add Toggle position ( left, right and middle ).'),
                __('Add Toggle size ( small, medium and large ).'),
            ],
        ],
    ],
    [
        'version' => __('v1.0.10', 'dusky-dark-mode'),
        'date'    => __('2024-06-08', 'dusky-dark-mode'),
        'changes' => [
            'fixes' => [
                __('fixes "Advanced Editor Tools" plugin issue.'),
                __('fixes classic editor dark mode issue.'),
            ],
        ],
    ],
    [
        'version' => __('v1.0.9', 'dusky-dark-mode'),
        'date'    => __('2024-18-07', 'dusky-dark-mode'),
        'changes' => [
            'fixes'        => [
                __('Fix background image replacement with classic and Gutenberg editor support.'),
                __('Fix Exclude elements/sections'),
                __('Fix flexible toggle issue'),
            ],
            'enhancements' => [
                __('Optimize dashboard UI'),
            ],
        ],
    ],
    [
        'version' => __('v1.0.8', 'dusky-dark-mode'),
        'date'    => __('2024-04-07', 'dusky-dark-mode'),
        'changes' => [
            'enhancements' => [
                __('Enhance file size and overall performance'),
            ],
        ],
    ],
    [
        'version' => __('v1.0.7', 'dusky-dark-mode'),
        'date'    => __('2024-02-07', 'dusky-dark-mode'),
        'changes' => [
            'new'          => [__('Capable of adding both toggle and dropdown type switchers to the WordPress menu', 'dusky-dark-mode')],
            'fixes'        => [__('Fix Missing Moon icon', 'dusky-dark-mode')],
            'enhancements' => [
                __('Optimize overall performance', 'dusky-dark-mode'),
            ],
        ],
    ],
    [
        'version' => __('v1.0.6', 'dusky-dark-mode'),
        'date'    => __('2024-30-06', 'dusky-dark-mode'),
        'changes' => [
            'fixes'        => [
                __('Fix Custom Default Toggle Size', 'dusky-dark-mode'),
                __('Fix Blinking Issue', 'dusky-dark-mode'),
                __('Fix Keyboard Shortcut on MacOS', 'dusky-dark-mode'),
                __('Fix Time Based Dark Mode Issue', 'dusky-dark-mode'),
            ],
            'enhancements' => [
                __('Optimize overall performance', 'dusky-dark-mode'),
            ],
        ],
    ],

    [
        'version' => __('v1.0.5', 'dusky-dark-mode'),
        'date'    => __('2024-20-05', 'dusky-dark-mode'),
        'changes' => [
            'fixes'        => [__('Fix JS error dark mode issue.', 'dusky-dark-mode')],
            'new'          => [__('Supported .gif file in image replacement', 'dusky-dark-mode')],
            'enhancements' => [
                __('Update plugin UI', 'dusky-dark-mode'),
                __('Update Getting Started Page UI', 'dusky-dark-mode'),
                __('Improved overall plugin performance.', 'dusky-dark-mode'),
            ],
        ],
    ],
    [
        'version' => __('v1.0.4', 'dusky-dark-mode'),
        'date'    => __('2024-08-02', 'dusky-dark-mode'),
        'changes' => [
            'fixes'        => [__('Fix some issues.', 'dusky-dark-mode')],
            'new'          => [__('Add total 40+ toggle button.', 'dusky-dark-mode')],
            'enhancements' => [__('Optimize files.', 'dusky-dark-mode')],
        ],
    ],
    [
        'version' => __('v1.0.3', 'dusky-dark-mode'),
        'date'    => __('2024-29-01', 'dusky-dark-mode'),
        'changes' => [
            'fixes' => [__('Fix 500 errors in aJax', 'dusky-dark-mode')],
        ],
    ],
    [
        'version' => __('v1.0.2', 'dusky-dark-mode'),
        'date'    => __('2024-15-01', 'dusky-dark-mode'),
        'changes' => [
            'fixes'        => [__('Fix mobile dark mode issue.', 'dusky-dark-mode')],
            'new'          => [
                __('Added auto save settings.', 'dusky-dark-mode'),
                __('Added 14+ new dark mode color presets.', 'dusky-dark-mode'),
                __('Added 15+ new dark mode toggler.', 'dusky-dark-mode'),
                __('Added dark mode Live Editor.', 'dusky-dark-mode'),
                __('Added dark mode usage analytics.', 'dusky-dark-mode'),
                __('Added images and videos settings.', 'dusky-dark-mode'),
                __('Added user role based dark mode.', 'dusky-dark-mode'),
                __('Added URL parameter.', 'dusky-dark-mode'),
                __('Added color adjustments settings.', 'dusky-dark-mode'),
                __('Added flexible toggle position.', 'dusky-dark-mode'),
                __('Added frontend and backend toggler position settings.', 'dusky-dark-mode'),
            ],
            'enhancements' => [
                __('Improved overall plugin performance.', 'dusky-dark-mode'),
                __('Improved toggle switcher.', 'dusky-dark-mode'),
            ],
        ],
    ],
    [
        'version' => __('v1.0.1', 'dusky-dark-mode'),
        'date'    => __('2024-11-01', 'dusky-dark-mode'),
        'changes' => [
            'fixes'        => [__('Fix JS error dark mode issue.', 'dusky-dark-mode')],
            'enhancements' => [__('Reduced the javascript file size.', 'dusky-dark-mode')],
        ],
    ],
    [
        'version' => __('v1.0.0', 'dusky-dark-mode'),
        'date'    => __('2024-18-01', 'dusky-dark-mode'),
        'changes' => [
            'initial-release' => [__('First Version of Dusky Dark Mode', 'dusky-dark-mode')],
        ],
    ],
];

$basic_usages = [
    [
        'question' => __('How to Activate Free Version of Dusky Dark Mode', 'dusky-dark-mode'),
        'answer'   => '<h2>Installing and activating the Dusky Dark Mode plugin on your WordPress website is incredibly simple.</h2>

        <p><strong>Just follow these steps:</strong></p>
        <ul>
            <li>Go to plugins and click on the active license</li>
            <li>Allow options and use the settings</li>
        </ul>

        <h2>Video Overview</h2>
        <div class="dusky-iframe-responsive">
            <iframe src="https://www.youtube.com/embed/EZq4djWwIV8?si=wuurqaNXXlZ027Wa" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
        </div>
        ',
    ],
    [
        'question' => __('How to Activate Pro Version of Dusky Dark Mode', 'dusky-dark-mode'),
        'answer'   => '<h2>Installing and activating the Dusky Dark Mode plugin on your WordPress website is incredibly simple.</h2>

        <p><strong>Just follow these steps:</strong></p>
        <ul>
            <li>Go to plugins and click on the active license</li>
            <li>Allow options and use the settings</li>
        </ul>

        <h2>Video Overview</h2>
        <div class="dusky-iframe-responsive">
            <iframe width="560" height="315" src="https://www.youtube.com/embed/yPREoWo4ZDQ?si=tJ1tSX_mV6fusENn" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
        </div>
        ',
    ],
    [
        'question' => __('How to Enable Frontend Dark Mode in Dusky Dark Mode', 'dusky-dark-mode'),
        'answer'   => '<h2>Lets follow the steps: </h2>

        <p><strong>Just follow these steps:</strong></p>
        <ul>
            <li>Go to setting</li>
            <li>Click on the toggle to enable</li>
        </ul>

        <h2>Video Overview</h2>
        <div class="dusky-iframe-responsive">
            <iframe width="560" height="315" src="https://www.youtube.com/embed/igkbvcvIc2E?si=fOWfRu3vazqXIK7P" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
        </div>
        ',
    ],
    [
        'question' => __('How to Change Frontend Toggler in Dusky Dark Mode', 'dusky-dark-mode'),
        'answer'   => '<h2>Lets follow the steps: </h2>

        <p><strong>Just follow these steps:</strong></p>
        <ul>
            <li>Go to setting</li>
            <li>Click on the Frontend tab to enable</li>
        </ul>

        <h2>Video Overview</h2>
        <div class="dusky-iframe-responsive">
            <iframe width="560" height="315" src="https://www.youtube.com/embed/eACz_jzeaIw?si=h4sLl4FaFCHko3tZ" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
        </div>
        ',
    ],
];
