<?php

defined('ABSPATH') or exit('Hey, what are you doing here? You silly human!');

class Dusky_Shortcode
{

    private static $instance = null;

    public function __construct()
    {
        add_shortcode('dusky_toggle', [$this, 'dusky_toggle']);
    }

    public function dusky_toggle()
    {
        if (! dusky_enable_devise()) {
            return '';
        }
        return $this->render_floating_toggle();
    }

    public function render_floating_toggle()
    {
        wp_enqueue_script('dusky-frontend');
        $mode = dusky_get_mode();
        $toggleStyle = dusky_get_settings('toggleStyle', '1');
        $toggleSize = dusky_get_settings('toggleSize', 'medium');

        return sprintf('<div data-dusky_mode="%s" class="dusky-toggle-wrap dusky-shortcode-toggle dusky-active-%s dusky-toggle-style-%s dusky-toggle-%s dusky-ignore"><div class="dusky-toggle-icon"><div class="dusky-toggle-main-icon"></div></div><div class="dusky-toggle-text"><span class="dusky-toggle-%s">%s</span></div></div>', esc_attr($mode), esc_attr($mode), esc_attr($toggleStyle), esc_attr($toggleSize), esc_attr($mode), esc_html(ucfirst($mode)));
    }

    public static function instance()
    {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }

        return self::$instance;
    }
}

Dusky_Shortcode::instance();
