<?php

defined( 'ABSPATH' ) or exit( 'Hey, what are you doing here? You silly human!' );

if ( ! class_exists( 'Dusky_Mail' ) ) {
    class Dusky_Mail {
        public static function send() {
            $settings = dusky_get_settings();
            $to = $settings['reportingEmail'];
            $subject = $settings['reportingEmailSub'];

            // Load the email template content from a file
            $template_file = DUSKY_INC . "/views/mail.php";
            $response = wp_remote_get( $template_file );

            if ( is_array( $response ) && ! is_wp_error( $response ) ) {
                $body = isset( $response['body'] ) ? $response['body'] : null;

                if ( ! $body ) {
                    return;
                }

                $title = 'Dusky Dark Mode';
                $dark_mode_users = 10;
                $light_mode_users = 5;
                $total_mode_users = 15;
                $copyright_text = __( 'Dusky Dark Mode', 'dusky-dark-mode' );
                $site_url = dusky_get_settings( 'fromReportingEmail', 'Site Title: <support@example.com>' );
                $subject = dusky_get_settings( 'reportingEmailSub', 'Site Title: <support@example.com>' );

                $body = str_replace( '{{title}}', $title, $body );
                $body = str_replace( '{{subject}}', $subject, $body );
                $body = str_replace( '{{dark_mode_users}}', $dark_mode_users, $body );
                $body = str_replace( '{{light_mode_users}}', $light_mode_users, $body );
                $body = str_replace( '{{total_mode_users}}', $total_mode_users, $body );
                $body = str_replace( '{{copyright_text}}', gmdate( 'Y' ) . ' ' . $copyright_text, $body );
                $headers = [];

                $headers[] = "Content-Type: text/html; charset=UTF-8";
                $headers[] = "From: {$site_url}>";

                wp_mail( $to, $subject, $body, $headers );
            }

        }

        private static $instance = null;

        public static function instance() {
            if ( is_null( self::$instance ) ) {
                self::$instance = new self();
            }

            return self::$instance;
        }
    }
}

Dusky_Mail::instance();