<?php

defined( 'ABSPATH' ) or exit( 'Hey, what are you doing here? You silly human!' );

if ( ! class_exists( 'Dusky_Install' ) ) {
    class Dusky_Install {

        public static function activate() {
            if ( ! class_exists( 'Dusky_Update' ) ) {
                require_once DUSKY_INC . '/class-update.php';
            }

            $updater = new Dusky_Update();

            if ( $updater->needs_update() ) {
                $updater->perform_updates();
            } else {
                self::create_default_data();
                self::create_tables();
            }
        }

        private static function create_tables() {
            global $wpdb;

            $wpdb->hide_errors();

            require_once ABSPATH . 'wp-admin/includes/upgrade.php';

            $tables = [

                // Analytics table
                "CREATE TABLE IF NOT EXISTS {$wpdb->prefix}dusky_analytics(
                    id bigint(20) NOT NULL AUTO_INCREMENT,
                    unique_id VARCHAR(32) NOT NULL,
                    active_mode tinyint(1) NOT NULL DEFAULT 0,
                    activation bigint(20) NOT NULL DEFAULT 0,
                    deactivation bigint(20) NOT NULL DEFAULT 0,
                    view bigint(20) NOT NULL DEFAULT 0,
                    dark_view bigint(20) NOT NULL DEFAULT 0,
                    date TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
                    PRIMARY KEY (id),
                    UNIQUE KEY (id)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;",
            ];

            foreach ( $tables as $table ) {
                dbDelta( $table );
            }
        }

        private static function create_default_data() {

            $version = get_option( 'dusky_version', '0' );
            $dusky_installed = get_option( 'dusky_installed' );

            if ( ! $dusky_installed ) {
                update_option( 'dusky_installed', time() );
            }

            if ( ! $version ) {
                update_option( 'dusky_version', DUSKY_VERSION );
            }

        }

    }

}
