<?php
/*
 * Plugin Name:       Dusky Dark Mode
 * Plugin URI:        https://codeconfig.dev/dusky-dark-mode/
 * Description:       Dusky Dark Mode instantly activates an elegant dark mode for your website, adapting to the user's operating system. Compatible with macOS, Windows, Android, and iOS platforms.
 * Version:           1.0.15
 * Requires at least: 5.2
 * Requires PHP:      7.4
 * Author:            CodeConfig
 * Author URI:        https://codeconfig.dev/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       dusky-dark-mode
 * Domain Path:       /languages
 */

defined('ABSPATH') or exit('Hey, what are you doing here? You silly human!');

if (function_exists('dusky_fs')) {
    dusky_fs()->set_basename(true, __FILE__);
} else {
    // DO NOT REMOVE THIS IF, IT IS ESSENTIAL FOR THE `function_exists` CALL ABOVE TO PROPERLY WORK.
    if (! function_exists('dusky_fs')) {

        // ... Freemius integration snippet ...
        if (! function_exists('dusky_fs')) {
            // Create a helper function for easy SDK access.
            function dusky_fs()
            {
                global $dusky_fs;

                if (! isset($dusky_fs)) {
                    // Include Freemius SDK.
                    require_once dirname(__FILE__) . '/freemius/start.php';

                    $dusky_fs = fs_dynamic_init([
                        'id'                  => '13479',
                        'slug'                => 'dusky-dark-mode',
                        'premium_slug'        => 'dusky-dark-mode-pro',
                        'type'                => 'plugin',
                        'public_key'          => 'pk_f000affd6bab019a97a45b88a65de',
                        'is_premium'          => true,
                        'premium_suffix'      => '(PRO)',
                        'has_premium_version' => false,
                        'has_addons'          => false,
                        'has_paid_plans'      => true,
                        'trial'               => [
                            'days'               => 7,
                            'is_require_payment' => false,
                        ],
                        'has_affiliation'     => 'selected',
                        'menu'                => [
                            'slug'        => 'dusky-dark-mode',
                            'first-path'  => 'admin.php?page=dusky-dark-mode',
                            'affiliation' => false,
                        ],
                    ]);
                }

                return $dusky_fs;
            }

            // Init Freemius.
            dusky_fs();
            // Signal that SDK was initiated.
            do_action('dusky_fs_loaded');
        }
    }

    //  Define constant
    define('DUSKY_VERSION', '1.0.15');
    define('DUSKY_FILE', __FILE__);
    define('DUSKY_PATH', dirname(DUSKY_FILE));
    define('DUSKY_INC', DUSKY_PATH . '/inc');
    define('DUSKY_URL', plugin_dir_url(__FILE__));
    define('DUSKY_ASSETS', DUSKY_URL . 'assets');

    if (realpath(DUSKY_INC . '/dusky-base.php')) {
        require_once realpath(DUSKY_INC . '/dusky-base.php');
    }
}
